package gov.va.vamf.scheduling.direct.datalayer.appointment;


import gov.va.vamf.scheduling.direct.domain.ExpressCareReason;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ExpressCareReasonService {

    @Autowired
    private ExpressCareReasonRepository expressCareReasonRepository;

    public List<ExpressCareReason> fetch() {
        List<ExpressCareReason> expressCareReasons = expressCareReasonRepository.findAll(new Sort(Sort.Direction.ASC, "id"));
        return expressCareReasons;
    }

    public ExpressCareReason fetchById(String id) {
        ExpressCareReason expressCareReason = expressCareReasonRepository.findById(id);
        return expressCareReason;
    }

    public ExpressCareReason save(ExpressCareReason expressCareReason) {
        ExpressCareReason savedExpressCareReason = expressCareReasonRepository.save(expressCareReason);
        return savedExpressCareReason;
    }
}
